/* Copyright 2009-2013 David Hadka
 *
 * This file is part of the MOEA Framework.
 *
 * The MOEA Framework is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or (at your
 * option) any later version.
 *
 * The MOEA Framework is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 * License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with the MOEA Framework.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.moeaframework.problem.WFG;

import org.junit.Test;
import org.moeaframework.core.Problem;
import org.moeaframework.problem.ProblemTest;

public class WFGTest extends ProblemTest {

	@Test
	public void testWFG1_2D() throws Exception {
		test("WFG1", 2);
	}

	@Test
	public void testWFG1_3D() throws Exception {
		test("WFG1", 3);
	}

	@Test
	public void testWFG1_4D() throws Exception {
		test("WFG1", 4);
	}

	@Test
	public void testWFG1_5D() throws Exception {
		test("WFG1", 5);
	}

	@Test
	public void testWFG1_6D() throws Exception {
		test("WFG1", 6);
	}

	@Test
	public void testWFG1_7D() throws Exception {
		test("WFG1", 7);
	}

	@Test
	public void testWFG1_8D() throws Exception {
		test("WFG1", 8);
	}

	@Test
	public void testWFG2_2D() throws Exception {
		test("WFG2", 2);
	}

	@Test
	public void testWFG2_3D() throws Exception {
		test("WFG2", 3);
	}

	@Test
	public void testWFG2_4D() throws Exception {
		test("WFG2", 4);
	}

	@Test
	public void testWFG2_5D() throws Exception {
		test("WFG2", 5);
	}

	@Test
	public void testWFG2_6D() throws Exception {
		test("WFG2", 6);
	}

	@Test
	public void testWFG2_7D() throws Exception {
		test("WFG2", 7);
	}

	@Test
	public void testWFG2_8D() throws Exception {
		test("WFG2", 8);
	}

	@Test
	public void testWFG3_2D() throws Exception {
		test("WFG3", 2);
	}

	@Test
	public void testWFG3_3D() throws Exception {
		test("WFG3", 3);
	}

	@Test
	public void testWFG3_4D() throws Exception {
		test("WFG3", 4);
	}

	@Test
	public void testWFG3_5D() throws Exception {
		test("WFG3", 5);
	}

	@Test
	public void testWFG3_6D() throws Exception {
		test("WFG3", 6);
	}

	@Test
	public void testWFG3_7D() throws Exception {
		test("WFG3", 7);
	}

	@Test
	public void testWFG3_8D() throws Exception {
		test("WFG3", 8);
	}

	@Test
	public void testWFG4_2D() throws Exception {
		test("WFG4", 2);
	}

	@Test
	public void testWFG4_3D() throws Exception {
		test("WFG4", 3);
	}

	@Test
	public void testWFG4_4D() throws Exception {
		test("WFG4", 4);
	}

	@Test
	public void testWFG4_5D() throws Exception {
		test("WFG4", 5);
	}

	@Test
	public void testWFG4_6D() throws Exception {
		test("WFG4", 6);
	}

	@Test
	public void testWFG4_7D() throws Exception {
		test("WFG4", 7);
	}

	@Test
	public void testWFG4_8D() throws Exception {
		test("WFG4", 8);
	}

	@Test
	public void testWFG5_2D() throws Exception {
		test("WFG5", 2);
	}

	@Test
	public void testWFG5_3D() throws Exception {
		test("WFG5", 3);
	}

	@Test
	public void testWFG5_4D() throws Exception {
		test("WFG5", 4);
	}

	@Test
	public void testWFG5_5D() throws Exception {
		test("WFG5", 5);
	}

	@Test
	public void testWFG5_6D() throws Exception {
		test("WFG5", 6);
	}

	@Test
	public void testWFG5_7D() throws Exception {
		test("WFG5", 7);
	}

	@Test
	public void testWFG5_8D() throws Exception {
		test("WFG5", 8);
	}

	@Test
	public void testWFG6_2D() throws Exception {
		test("WFG6", 2);
	}

	@Test
	public void testWFG6_3D() throws Exception {
		test("WFG6", 3);
	}

	@Test
	public void testWFG6_4D() throws Exception {
		test("WFG6", 4);
	}

	@Test
	public void testWFG6_5D() throws Exception {
		test("WFG6", 5);
	}

	@Test
	public void testWFG6_6D() throws Exception {
		test("WFG6", 6);
	}

	@Test
	public void testWFG6_7D() throws Exception {
		test("WFG6", 7);
	}

	@Test
	public void testWFG6_8D() throws Exception {
		test("WFG6", 8);
	}

	@Test
	public void testWFG7_2D() throws Exception {
		test("WFG7", 2);
	}

	@Test
	public void testWFG7_3D() throws Exception {
		test("WFG7", 3);
	}

	@Test
	public void testWFG7_4D() throws Exception {
		test("WFG7", 4);
	}

	@Test
	public void testWFG7_5D() throws Exception {
		test("WFG7", 5);
	}

	@Test
	public void testWFG7_6D() throws Exception {
		test("WFG7", 6);
	}

	@Test
	public void testWFG7_7D() throws Exception {
		test("WFG7", 7);
	}

	@Test
	public void testWFG7_8D() throws Exception {
		test("WFG7", 8);
	}

	@Test
	public void testWFG8_2D() throws Exception {
		test("WFG8", 2);
	}

	@Test
	public void testWFG8_3D() throws Exception {
		test("WFG8", 3);
	}

	@Test
	public void testWFG8_4D() throws Exception {
		test("WFG8", 4);
	}

	@Test
	public void testWFG8_5D() throws Exception {
		test("WFG8", 5);
	}

	@Test
	public void testWFG8_6D() throws Exception {
		test("WFG8", 6);
	}

	@Test
	public void testWFG8_7D() throws Exception {
		test("WFG8", 7);
	}

	@Test
	public void testWFG8_8D() throws Exception {
		test("WFG8", 8);
	}

	@Test
	public void testWFG9_2D() throws Exception {
		test("WFG9", 2);
	}

	@Test
	public void testWFG9_3D() throws Exception {
		test("WFG9", 3);
	}

	@Test
	public void testWFG9_4D() throws Exception {
		test("WFG9", 4);
	}

	@Test
	public void testWFG9_5D() throws Exception {
		test("WFG9", 5);
	}

	@Test
	public void testWFG9_6D() throws Exception {
		test("WFG9", 6);
	}

	@Test
	public void testWFG9_7D() throws Exception {
		test("WFG9", 7);
	}

	@Test
	public void testWFG9_8D() throws Exception {
		test("WFG9", 8);
	}

	public void test(String problem, int M) throws Exception {
		jmetal.core.Problem problemA;
		Problem problemB;

		int k = M - 1;
		int l = 10;

		if (problem.equals("WFG1")) {
			problemA = new jmetal.problems.WFG.WFG1("Real", k, l, M);
			problemB = new org.moeaframework.problem.WFG.WFG1(k, l, M);
		} else if (problem.equals("WFG2")) {
			problemA = new jmetal.problems.WFG.WFG2("Real", k, l, M);
			problemB = new org.moeaframework.problem.WFG.WFG2(k, l, M);
		} else if (problem.equals("WFG3")) {
			problemA = new jmetal.problems.WFG.WFG3("Real", k, l, M);
			problemB = new org.moeaframework.problem.WFG.WFG3(k, l, M);
		} else if (problem.equals("WFG4")) {
			problemA = new jmetal.problems.WFG.WFG4("Real", k, l, M);
			problemB = new org.moeaframework.problem.WFG.WFG4(k, l, M);
		} else if (problem.equals("WFG5")) {
			problemA = new jmetal.problems.WFG.WFG5("Real", k, l, M);
			problemB = new org.moeaframework.problem.WFG.WFG5(k, l, M);
		} else if (problem.equals("WFG6")) {
			problemA = new jmetal.problems.WFG.WFG6("Real", k, l, M);
			problemB = new org.moeaframework.problem.WFG.WFG6(k, l, M);
		} else if (problem.equals("WFG7")) {
			problemA = new jmetal.problems.WFG.WFG7("Real", k, l, M);
			problemB = new org.moeaframework.problem.WFG.WFG7(k, l, M);
		} else if (problem.equals("WFG8")) {
			problemA = new jmetal.problems.WFG.WFG8("Real", k, l, M);
			problemB = new org.moeaframework.problem.WFG.WFG8(k, l, M);
		} else if (problem.equals("WFG9")) {
			problemA = new jmetal.problems.WFG.WFG9("Real", k, l, M);
			problemB = new org.moeaframework.problem.WFG.WFG9(k, l, M);
		} else {
			throw new IllegalArgumentException();
		}

		test(problemA, problemB);
	}

}
