CREATE DATABASE  IF NOT EXISTS `db_eecluster_jdbcrealm` /*!40100 DEFAULT CHARACTER SET latin1 */;
USE `db_eecluster_jdbcrealm`;
-- MySQL dump 10.13  Distrib 5.6.11, for Win32 (x86)
--
-- Host: 127.0.0.1    Database: db_eecluster_jdbcrealm
-- ------------------------------------------------------
-- Server version	5.5.27

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `users`
--

DROP TABLE IF EXISTS `users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `users` (
  `username` varchar(255) NOT NULL,
  `password` varchar(255) NOT NULL,
  `securityGroup` int(11) NOT NULL,
  PRIMARY KEY (`username`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

CREATE DATABASE  IF NOT EXISTS `db_eecluster` /*!40100 DEFAULT CHARACTER SET latin1 */;
USE `db_eecluster`;
-- MySQL dump 10.13  Distrib 5.6.24, for Win64 (x86_64)
--
-- Host: 127.0.0.1    Database: db_eecluster
-- ------------------------------------------------------
-- Server version	5.5.27

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `action_log`
--

DROP TABLE IF EXISTS `action_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `action_log` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `timestamp` timestamp NULL DEFAULT NULL,
  `hostname` varchar(100) DEFAULT NULL,
  `action` int(11) DEFAULT NULL,
  `reason` varchar(150) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `log_hostname_idx` (`hostname`),
  CONSTRAINT `log_hostname` FOREIGN KEY (`hostname`) REFERENCES `host` (`name`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=478 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `cpu`
--

DROP TABLE IF EXISTS `cpu`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cpu` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `hostname` varchar(100) NOT NULL,
  `model_name` varchar(100) DEFAULT NULL,
  `mhz` bigint(20) DEFAULT NULL,
  `cache` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cpu_hostname` (`hostname`),
  CONSTRAINT `cpu_hostname` FOREIGN KEY (`hostname`) REFERENCES `host` (`name`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3101 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `current_job`
--

DROP TABLE IF EXISTS `current_job`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `current_job` (
  `jobId` varchar(50) NOT NULL,
  `jobname` varchar(100) NOT NULL,
  `queue_name` varchar(100) DEFAULT NULL,
  `user` varchar(100) NOT NULL,
  `priority` double DEFAULT NULL,
  `start_time` timestamp NULL DEFAULT NULL,
  `slots` int(11) DEFAULT NULL,
  `utime` double DEFAULT NULL,
  `stime` double DEFAULT NULL,
  `cputime` double DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  PRIMARY KEY (`jobId`),
  KEY `job_queue_idx` (`queue_name`),
  KEY `user_idx` (`user`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `gpu`
--

DROP TABLE IF EXISTS `gpu`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `gpu` (
  `id` varchar(100) NOT NULL,
  `hostname` varchar(100) NOT NULL,
  `model_name` varchar(100) DEFAULT NULL,
  `fan_speed` varchar(45) DEFAULT NULL,
  `gpu_util` varchar(45) DEFAULT NULL,
  `memory_util` varchar(45) DEFAULT NULL,
  `gpu_temp` varchar(45) DEFAULT NULL,
  `power_draw` varchar(45) DEFAULT NULL,
  `graphics_clock` varchar(45) DEFAULT NULL,
  `sm_clock` varchar(45) DEFAULT NULL,
  `mem_clock` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`,`hostname`),
  KEY `gpu_hostname_idx` (`hostname`),
  CONSTRAINT `gpu_hostname` FOREIGN KEY (`hostname`) REFERENCES `host` (`name`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `host`
--

DROP TABLE IF EXISTS `host`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `host` (
  `name` varchar(100) NOT NULL,
  `MAC_address` varchar(50) DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  `rms_status` int(11) DEFAULT '0',
  `nodeClass` varchar(100) DEFAULT NULL,
  `PSU_ipmi_sync` bit(1) DEFAULT NULL,
  `power_on_off_ipmi` bit(1) DEFAULT NULL,
  `masterNetworkEthernetInterface` varchar(45) DEFAULT NULL,
  `hostEthernetInterface` varchar(45) DEFAULT NULL,
  `architecture` varchar(150) DEFAULT NULL,
  `n_cpus` int(11) DEFAULT NULL,
  `n_sockets` int(11) DEFAULT NULL,
  `n_cores` int(11) DEFAULT NULL,
  `ram_gb` double DEFAULT NULL,
  `load_avg` double DEFAULT NULL,
  `total_memory` varchar(45) DEFAULT NULL,
  `used_memory` varchar(45) DEFAULT NULL,
  `total_swap` varchar(45) DEFAULT NULL,
  `used_swap` varchar(45) DEFAULT NULL,
  `total_virtual_memory` varchar(45) DEFAULT NULL,
  `issued_command` int(11) DEFAULT NULL,
  `command_timestamp` timestamp NULL DEFAULT NULL,
  `timedOut_timestamp` timestamp NULL DEFAULT NULL,
  `properties` varchar(100) DEFAULT NULL,
  `ntype` varchar(45) DEFAULT NULL,
  `last_exec` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`name`),
  KEY `class_node_idx` (`nodeClass`),
  CONSTRAINT `class_node` FOREIGN KEY (`nodeClass`) REFERENCES `nodeclass` (`name`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `host_results_log`
--

DROP TABLE IF EXISTS `host_results_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `host_results_log` (
  `host_name` varchar(100) NOT NULL,
  `cumulative_time_idle` bigint(20) DEFAULT NULL,
  `cumulative_time_exec` bigint(20) DEFAULT NULL,
  `cumulative_time_off` bigint(20) DEFAULT NULL,
  `cumulative_time_starting` bigint(20) DEFAULT NULL,
  `cumulative_time_shuttingDown` bigint(20) DEFAULT NULL,
  `cumulative_reconfigurations` bigint(20) DEFAULT NULL,
  `manufacturingIndirectEnergyCost_Wh` double DEFAULT NULL,
  `manufacturingIndirectEnergyCost_euros` double DEFAULT NULL,
  `manufacturingIndirectEnergyCost_co2` double DEFAULT NULL,
  `cumulativeDirectEnergyCost_Wh` double DEFAULT NULL,
  `cumulativeDirectEnergyCost_euros` double DEFAULT NULL,
  `cumulativeDirectEnergyCost_co2` double DEFAULT NULL,
  `cumulativeReplacementCost_euros` double DEFAULT NULL,
  `cumulativeIndirectEnergyCost_Wh` double DEFAULT NULL,
  `cumulativeIndirectEnergyCost_co2` double DEFAULT NULL,
  PRIMARY KEY (`host_name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `host_status_log`
--

DROP TABLE IF EXISTS `host_status_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `host_status_log` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `host_name` varchar(100) NOT NULL,
  `status` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=145069 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `ipmicard`
--

DROP TABLE IF EXISTS `ipmicard`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ipmicard` (
  `card_address` varchar(100) NOT NULL,
  `hostname` varchar(100) NOT NULL,
  `username` varchar(100) NOT NULL,
  `password` varchar(100) NOT NULL,
  PRIMARY KEY (`card_address`),
  KEY `hostname_idx` (`hostname`),
  CONSTRAINT `ipmicard_hostname` FOREIGN KEY (`hostname`) REFERENCES `host` (`name`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `job`
--

DROP TABLE IF EXISTS `job`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `job` (
  `jobId` varchar(50) NOT NULL,
  `jobname` varchar(100) NOT NULL,
  `queue_name` varchar(100) NOT NULL,
  `user` varchar(100) NOT NULL,
  `priority` double DEFAULT NULL,
  `submission_time` timestamp NULL DEFAULT NULL,
  `start_time` timestamp NULL DEFAULT NULL,
  `end_time` timestamp NULL DEFAULT NULL,
  `pe_name` varchar(100) DEFAULT NULL,
  `slots` int(11) DEFAULT NULL,
  `exit_status` int(11) DEFAULT NULL,
  `completed` bit(1) DEFAULT NULL,
  `utime` double DEFAULT NULL,
  `stime` double DEFAULT NULL,
  `cputime` double DEFAULT NULL,
  PRIMARY KEY (`jobId`),
  KEY `job_queue_idx` (`queue_name`),
  KEY `pe_name_idx` (`pe_name`),
  KEY `user_idx` (`user`),
  CONSTRAINT `job_pe_name` FOREIGN KEY (`pe_name`) REFERENCES `parallel_environment` (`name`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `job_queue` FOREIGN KEY (`queue_name`) REFERENCES `queue` (`name`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `job_user` FOREIGN KEY (`user`) REFERENCES `user` (`username`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `mic`
--

DROP TABLE IF EXISTS `mic`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `mic` (
  `id` varchar(100) NOT NULL,
  `hostname` varchar(100) NOT NULL,
  `model_name` varchar(45) DEFAULT NULL,
  `active_cores` int(11) DEFAULT NULL,
  `frequency` varchar(45) DEFAULT NULL,
  `memory` varchar(45) DEFAULT NULL,
  `temp` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `mic_hostname_idx` (`hostname`),
  CONSTRAINT `mic_hostname` FOREIGN KEY (`hostname`) REFERENCES `host` (`name`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `nodeclass`
--

DROP TABLE IF EXISTS `nodeclass`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `nodeclass` (
  `name` varchar(100) NOT NULL,
  `description` varchar(500) DEFAULT NULL,
  `performance_index` double DEFAULT NULL,
  `pic` varchar(500) DEFAULT NULL,
  `useful_life_percentage` double DEFAULT NULL,
  `serverBaseAFR` double DEFAULT NULL,
  `avg_CPU_temp_before` double DEFAULT NULL,
  `avg_CPU_temp_after` double DEFAULT NULL,
  `peak_CPU_temp` double DEFAULT NULL,
  `hddBaseAFR` double DEFAULT NULL,
  `hddBaseStartStopFreq` double DEFAULT NULL,
  `number_hdd` int(11) DEFAULT NULL,
  `serverManufacturingCostEnergy_kWh` double DEFAULT NULL,
  `serverManufacturingCostKgCO2` double DEFAULT NULL,
  `serverManufacturingCostEuros` double DEFAULT NULL,
  `hddManufacturingCostEnergy_kWh` double DEFAULT NULL,
  `hddManufacturingCostKgCO2` double DEFAULT NULL,
  `hddManufacturingCostEuros` double DEFAULT NULL,
  `serverOperatingHighPowerConsumption` double DEFAULT NULL,
  `serverOperatingLowPowerConsumption` double DEFAULT NULL,
  `serverOperatingKWattCostEuros` double DEFAULT NULL,
  `serverOperatingKWattCostKgCO2` double DEFAULT NULL,
  PRIMARY KEY (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `parallel_environment`
--

DROP TABLE IF EXISTS `parallel_environment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `parallel_environment` (
  `name` varchar(100) NOT NULL,
  `slots` int(11) DEFAULT NULL,
  `allocationRule` varchar(45) DEFAULT NULL,
  `type` int(11) DEFAULT NULL,
  PRIMARY KEY (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `psu_power_usage`
--

DROP TABLE IF EXISTS `psu_power_usage`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `psu_power_usage` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `hostname` varchar(100) NOT NULL,
  `consumption` double NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hostname_idx` (`hostname`),
  CONSTRAINT `psu_hostname` FOREIGN KEY (`hostname`) REFERENCES `host` (`name`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=5538 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `queue`
--

DROP TABLE IF EXISTS `queue`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `queue` (
  `name` varchar(100) NOT NULL,
  `type` varchar(45) DEFAULT NULL,
  `slots` int(11) DEFAULT NULL,
  `enabled` bit(1) DEFAULT b'1',
  `started` bit(1) DEFAULT b'1',
  `priority` int(11) DEFAULT '0',
  `total_jobs` int(11) DEFAULT '0',
  `max_running_jobs` int(11) DEFAULT '0',
  `max_queued_jobs_per_user` int(11) DEFAULT '0',
  `max_walltime` varchar(45) DEFAULT NULL,
  `idle_shutdown_timeout` int(11) DEFAULT NULL,
  PRIMARY KEY (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `queue_parallel_environment`
--

DROP TABLE IF EXISTS `queue_parallel_environment`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `queue_parallel_environment` (
  `queue_name` varchar(100) NOT NULL,
  `pe_name` varchar(100) NOT NULL,
  PRIMARY KEY (`queue_name`,`pe_name`),
  KEY `pe_name_idx` (`pe_name`),
  CONSTRAINT `pe_name` FOREIGN KEY (`pe_name`) REFERENCES `parallel_environment` (`name`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `queue_name` FOREIGN KEY (`queue_name`) REFERENCES `queue` (`name`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `queue_resource_usage`
--

DROP TABLE IF EXISTS `queue_resource_usage`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `queue_resource_usage` (
  `queue_name` varchar(100) NOT NULL,
  `hostname` varchar(100) NOT NULL,
  `slots_used` int(11) DEFAULT NULL,
  `slots` int(11) DEFAULT NULL,
  `slots_reserved` int(11) DEFAULT NULL,
  `state` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`queue_name`,`hostname`),
  KEY `queue_resource_host_idx` (`hostname`),
  CONSTRAINT `queue_resource_host` FOREIGN KEY (`hostname`) REFERENCES `host` (`name`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `queue_resource_usage` FOREIGN KEY (`queue_name`) REFERENCES `queue` (`name`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `queue_results_log`
--

DROP TABLE IF EXISTS `queue_results_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `queue_results_log` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `timestamp` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `queue_name` varchar(100) DEFAULT NULL,
  `percentile_waiting_duration_time_ratio` double DEFAULT NULL,
  `operatingMonetaryCost` double DEFAULT NULL,
  `replacementCost` double DEFAULT NULL,
  `carbonFootprint` double DEFAULT NULL,
  `cumulative_time_idle` bigint(20) DEFAULT NULL,
  `cumulative_time_exec` bigint(20) DEFAULT NULL,
  `cumulative_time_off` bigint(20) DEFAULT NULL,
  `cumulative_time_starting` bigint(20) DEFAULT NULL,
  `cumulative_time_shuttingDown` bigint(20) DEFAULT NULL,
  `cumulative_reconfigurations` bigint(20) DEFAULT NULL,
  `manufacturingIndirectEnergyCost_Wh` double DEFAULT NULL,
  `manufacturingIndirectEnergyCost_euros` double DEFAULT NULL,
  `manufacturingIndirectEnergyCost_co2` double DEFAULT NULL,
  `cumulativeDirectEnergyCost_Wh` double DEFAULT NULL,
  `cumulativeDirectEnergyCost_euros` double DEFAULT NULL,
  `cumulativeDirectEnergyCost_co2` double DEFAULT NULL,
  `cumulativeReplacementCost_euros` double DEFAULT NULL,
  `cumulativeIndirectEnergyCost_Wh` double DEFAULT NULL,
  `cumulativeIndirectEnergyCost_co2` double DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=102 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `queue_status_log`
--

DROP TABLE IF EXISTS `queue_status_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `queue_status_log` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `timestamp` timestamp NULL DEFAULT NULL,
  `queue_name` varchar(100) DEFAULT NULL,
  `running_hosts` int(11) DEFAULT NULL,
  `executing_job_hosts` int(11) DEFAULT NULL,
  `running_idle_hosts` int(11) DEFAULT NULL,
  `running_slots` int(11) DEFAULT NULL,
  `used_slots` int(11) DEFAULT NULL,
  `requested_slots` int(11) DEFAULT NULL,
  `executing_jobs` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `statu_log_queue_idx` (`queue_name`)
) ENGINE=InnoDB AUTO_INCREMENT=8415156 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `queue_user_group`
--

DROP TABLE IF EXISTS `queue_user_group`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `queue_user_group` (
  `groupname` varchar(100) NOT NULL,
  `queue_name` varchar(100) NOT NULL,
  `max_enqueued_jobs` int(11) DEFAULT NULL,
  `max_waiting_time` int(11) DEFAULT NULL,
  PRIMARY KEY (`groupname`,`queue_name`),
  KEY `queue_name_user_group_idx` (`queue_name`),
  CONSTRAINT `queue_name_user_group` FOREIGN KEY (`queue_name`) REFERENCES `queue` (`name`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `rules_configuration`
--

DROP TABLE IF EXISTS `rules_configuration`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `rules_configuration` (
  `conf_name` varchar(250) NOT NULL,
  `queue` varchar(100) NOT NULL,
  `enabled` bit(1) DEFAULT b'0',
  `type` varchar(20) NOT NULL,
  `max_avg_waiting_time` int(11) DEFAULT NULL,
  `min_avg_waiting_time` int(11) DEFAULT NULL,
  `max_queued_jobs` int(11) DEFAULT NULL,
  `min_queued_jobs` int(11) DEFAULT NULL,
  `max_idle_time` int(11) DEFAULT NULL,
  `w1` float DEFAULT NULL,
  `w2` float DEFAULT NULL,
  `w3` float DEFAULT NULL,
  `w4` float DEFAULT NULL,
  `w5` float DEFAULT NULL,
  PRIMARY KEY (`conf_name`,`queue`),
  KEY `queuename_idx` (`queue`),
  CONSTRAINT `queuename` FOREIGN KEY (`queue`) REFERENCES `queue` (`name`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `user`
--

DROP TABLE IF EXISTS `user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `user` (
  `username` varchar(100) NOT NULL,
  `fullname` varchar(500) DEFAULT NULL,
  `wallclock` double DEFAULT NULL,
  `utime` double DEFAULT NULL,
  `stime` double DEFAULT NULL,
  `cputime` double DEFAULT NULL,
  `memory` varchar(45) DEFAULT NULL,
  `io` double DEFAULT NULL,
  PRIMARY KEY (`username`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Table structure for table `user_group`
--

DROP TABLE IF EXISTS `user_group`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `user_group` (
  `username` varchar(100) NOT NULL,
  `groupname` varchar(100) NOT NULL,
  `queue_name` varchar(100) NOT NULL,
  PRIMARY KEY (`username`,`groupname`,`queue_name`),
  KEY `group_idx` (`groupname`),
  KEY `user_group_queue_idx` (`queue_name`),
  KEY `user_group_groupname_idx` (`groupname`,`queue_name`),
  CONSTRAINT `user_group_groupname` FOREIGN KEY (`groupname`, `queue_name`) REFERENCES `queue_user_group` (`groupname`, `queue_name`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `user_user_group` FOREIGN KEY (`username`) REFERENCES `user` (`username`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2018-12-17 23:46:40
