package es.uniovi.healthappv2;

import android.Manifest;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothManager;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.util.Log;
import android.view.View;

import androidx.appcompat.app.AppCompatActivity;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import androidx.viewpager.widget.ViewPager;

import com.google.android.material.appbar.AppBarLayout;
import com.google.android.material.tabs.TabLayout;

import es.uniovi.healthappv2.main.SectionsPagerAdapter;


public class MainActivity extends AppCompatActivity {


    private TabLayout tabLayout;
    private AppBarLayout appBarLayout;
    private ViewPager viewPager;
    private SectionsPagerAdapter sectionsPagerAdapter;

    PulseraFragment pF;
    RelojFragment rF;

    private BluetoothAdapter bluetoothAdapter;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);
        pF=new PulseraFragment();
        rF=new RelojFragment();
        setUpView();
        setUpViewPagerAdapter();

        //Permisos ubicacion necesarios
        if (ContextCompat.checkSelfPermission(this, Manifest.permission.ACCESS_FINE_LOCATION)
                != PackageManager.PERMISSION_GRANTED) {
            ActivityCompat.requestPermissions(this,
                    new String[]{Manifest.permission.ACCESS_FINE_LOCATION},
                    1);
            ActivityCompat.requestPermissions(this,
                    new String[]{Manifest.permission.ACCESS_COARSE_LOCATION},
                    1);
        }
        //Se solicita activar el BT, si no lo estuviera
        final BluetoothManager bluetoothManager =
                (BluetoothManager) getSystemService(Context.BLUETOOTH_SERVICE);
        bluetoothAdapter = bluetoothManager.getAdapter();
        if (bluetoothAdapter == null || !bluetoothAdapter.isEnabled()) {
            Intent enableBtIntent = new Intent(BluetoothAdapter.ACTION_REQUEST_ENABLE);
            startActivityForResult(enableBtIntent, 1);
        }
    }


    private void setUpView(){
        tabLayout = findViewById(R.id.tabLayout);
        appBarLayout = findViewById(R.id.appBarLayout);
        viewPager = findViewById(R.id.viewPager);
        sectionsPagerAdapter = new SectionsPagerAdapter(getSupportFragmentManager());
    }

    private void setUpViewPagerAdapter(){
        sectionsPagerAdapter.addFragment(pF, "Pulsera");
        sectionsPagerAdapter.addFragment(rF, "Reloj");
        viewPager.setAdapter(sectionsPagerAdapter);

        tabLayout.setupWithViewPager(viewPager);
        tabLayout.addOnTabSelectedListener(new TabLayout.OnTabSelectedListener() {
            @Override
            public void onTabSelected(TabLayout.Tab tab) {
                switch (tab.getPosition()){
                    case 0:
                        Log.d("TAG1", "Posicion: " + tabLayout.getSelectedTabPosition() + " Titulo: " + sectionsPagerAdapter.getPageTitle(tabLayout.getSelectedTabPosition()));
                        break;
                    case 1:
                        Log.d("TAG1", "Posicion: " + tabLayout.getSelectedTabPosition() + " Titulo: " + sectionsPagerAdapter.getPageTitle(tabLayout.getSelectedTabPosition()));
                        break;
                    case 2:
                        Log.d("TAG1", "Posicion: " + tabLayout.getSelectedTabPosition() + " Titulo: " + sectionsPagerAdapter.getPageTitle(tabLayout.getSelectedTabPosition()));
                        break;
                    default:
                        break;
                }
            }
            @Override
            public void onTabUnselected(TabLayout.Tab tab) { }
            @Override
            public void onTabReselected(TabLayout.Tab tab) { }
        });
    }




    // Botones del fragmento de la pulsera
    public void onClickBConectar(View view) {
        pF.onClickBConectar(view);
    }
    public void onClickBAhora(View view) {
        pF.onClickBAhora(view);
    }
    public void onClickBLeerFichero(View view) {
        pF.onClickBLeerFichero(view);
    }
    public void onClickBBuscar(View view){
        Intent myIntent = new Intent(this,BuscarPulseraService.class);
        startService(myIntent);
    }
    public void onClickBParar(View view){
        pF.onClickBParar(view);
    }
    public void onClickBConfirmar(View view){
        pF.onClickBConfirmar(view);
    }
    public void onClickBCalibrar(View view){
        pF.onClickBCalibrar(view);
    }

    //Botones del fragmento del reloj
    public void onClickBLeer(View view) {
        rF.onClickBLeer(view);
    }
    public void onClickBPintar(View view) {
        rF.onClickBPintar(view);
    }
    public void onClickBSolicitar(View view){
        rF.onClickBSolicitar(view);
    }


}