package es.uniovi.healthappv2;


import android.content.Context;
import android.content.res.Resources;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import android.util.Log;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.ProgressBar;
import android.widget.TableLayout;
import android.widget.TableRow;
import android.widget.TextView;
import android.widget.Toast;

import androidx.fragment.app.Fragment;

import com.github.mikephil.charting.charts.LineChart;
import com.github.mikephil.charting.components.XAxis;
import com.github.mikephil.charting.components.YAxis;
import com.github.mikephil.charting.data.Entry;
import com.github.mikephil.charting.data.LineData;
import com.github.mikephil.charting.data.LineDataSet;
import com.github.mikephil.charting.highlight.Highlight;
import com.github.mikephil.charting.interfaces.datasets.ILineDataSet;
import com.github.mikephil.charting.listener.OnChartValueSelectedListener;
import com.google.android.gms.tasks.OnSuccessListener;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.android.gms.wearable.CapabilityClient;
import com.google.android.gms.wearable.CapabilityInfo;
import com.google.android.gms.wearable.DataClient;
import com.google.android.gms.wearable.DataEvent;
import com.google.android.gms.wearable.DataEventBuffer;
import com.google.android.gms.wearable.DataItem;
import com.google.android.gms.wearable.DataMap;
import com.google.android.gms.wearable.DataMapItem;
import com.google.android.gms.wearable.Node;
import com.google.android.gms.wearable.Wearable;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.text.DecimalFormat;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;


/**
 * A simple {@link Fragment} subclass.
 */
public class RelojFragment extends Fragment implements DataClient.OnDataChangedListener {

    private TextView tProgreso;
    private ProgressBar progressBar;
    int progreso=0;

    ArrayList<Map.Entry<String, Double>> medias_pulso;
    LineChart lineChart;
    boolean fin_recepcion=false;

    Date primer_dia_grafico;

    //Variables para la tabla
    private TableLayout tabla;
    private ArrayList<TableRow> filas;
    private Resources rs;
    private int FILAS, COLUMNAS;

    public RelojFragment() {
    }


    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container,
                             Bundle savedInstanceState) {
        // Inflate the layout for this fragment
        return inflater.inflate(R.layout.fragment_reloj, container, false);
    }

    @Override
    public void onViewCreated(View view, Bundle savedInstanceState) {

        tProgreso = (TextView) getView().findViewById(R.id.tProgreso);
        progressBar = (ProgressBar) getView().findViewById(R.id.progressBar);
        progressBar.setMax(15);
        progressBar.setProgress(progreso);

        progressBar.setProgress(15);
        double p=100.0;
        tProgreso.setText(String.format("%.1f",p)+"%");

        medias_pulso = new ArrayList<>();
        lineChart = (LineChart) getView().findViewById(R.id.linechart);
        lineChart.setOnChartValueSelectedListener(chartListener);

        tabla = (TableLayout) getView().findViewById(R.id.tablaR);
        rs = getActivity().getResources();
        FILAS = COLUMNAS = 0;
        filas = new ArrayList<TableRow>();
        agregarCabecera(R.array.cabecera_tabla);
        for(int i = 0; i < 4; i++)
        {
            ArrayList<String> elementos = new ArrayList<String>();
            if (i == 0) {
                elementos.add("Sueño");
            }
            else if(i==1){
                elementos.add("Reposo");
            }
            else if(i==2){
                elementos.add("Moderada");
            }
            else if(i==3){
                elementos.add("Intensa");
            }

            elementos.add("N/A");
            elementos.add("N/A");
            elementos.add("N/A");
            agregarFilaTabla(elementos);
        }


        Wearable.getDataClient(getActivity()).addListener(this);

        //Dentro se llama tambien a obtenerMedias y pintarGrafico
        //solicitarDatosPulso();
        obtenerMedias();
        pintarGrafico();

    }

    //Listener para el gráfico. En funcion de donde se haga click se muestra en la tabla la info del dia seleccioando
    OnChartValueSelectedListener chartListener=new OnChartValueSelectedListener()
    {
        @Override
        public void onValueSelected(Entry e, Highlight h)
        {
            float x=e.getX();
            float y=e.getY();
            String fichero="";
            long milis;
            Date dia_sel;


            double actividad=0;
            double pm0=0;
            double pm1=0;
            double pm2=0;
            double pm3=0;

            double suma0=0;
            double suma1=0;
            double suma2=0;
            double suma3=0;

            int cont0=0;
            int cont1=0;
            int cont2=0;
            int cont3=0;

            double pmax0=0;
            double pmax1=0;
            double pmax2=0;
            double pmax3=0;
            double pmin0=300;
            double pmin1=300;
            double pmin2=300;
            double pmin3=300;

            if(x==0){
                String[] a=primer_dia_grafico.toString().split(" ");
                fichero="ActividadR_"+a[1]+"_"+a[2]+"_"+a[5]+".txt";
            }
            else{
                milis=primer_dia_grafico.getTime();
                milis=milis+(long)x*24*60*60*1000;
                dia_sel=new Date(milis);
                String[] a=dia_sel.toString().split(" ");
                fichero="ActividadR_"+a[1]+"_"+a[2]+"_"+a[5]+".txt";
            }

            try {

                InputStream inputStream = getActivity().openFileInput(fichero);

                if (inputStream != null) {
                    InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
                    BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                    String receiveString = "";
                    ArrayList<Double> pulsos_dia = new ArrayList();

                    while ((receiveString = bufferedReader.readLine()) != null) {
                        String[] linea = receiveString.split("&");
                        actividad=Double.parseDouble(linea[2]);
                        double pulso=Double.parseDouble(linea[1]);

                        if(pulso!=0) { //A veces devuelve 0 erroneamente o si no puede medir bien
                            if (actividad == 0) {
                                suma0 = suma0 + pulso;
                                cont0++;

                                if(pulso<pmin0){
                                    pmin0=pulso;
                                }
                                if(pulso>pmax0){
                                    pmax0=pulso;
                                }

                            } else if (actividad == 1) {
                                suma1 = suma1 + pulso;
                                cont1++;

                                if(pulso<pmin1){
                                    pmin1=pulso;
                                }
                                if(pulso>pmax1){
                                    pmax1=pulso;
                                }
                            } else if (actividad == 2) {
                                suma2 = suma2 + pulso;
                                cont2++;

                                if(pulso<pmin2){
                                    pmin2=pulso;
                                }
                                if(pulso>pmax2){
                                    pmax2=pulso;
                                }
                            } else if (actividad == 3) {
                                suma3 = suma3 + pulso;
                                cont3++;

                                if(pulso<pmin3){
                                    pmin3=pulso;
                                }
                                if(pulso>pmax3){
                                    pmax3=pulso;
                                }
                            }
                        }

                    }

                }
            } catch (FileNotFoundException ex) {
                Log.e("login activity", "File not found: " + ex.toString());
            } catch (IOException ex) {
                Log.e("login activity", "Can not read file: " + ex.toString());
            }

            pm0=suma0/cont0;
            pm1=suma1/cont1;
            pm2=suma2/cont2;
            pm3=suma3/cont3;

            actualizarTabla(pm0,pmin0,pmax0,pm1,pmin1,pmax1,pm2,pmin2,pmax2,pm3,pmin3,pmax3);


        }

        @Override
        public void onNothingSelected()
        {

        }
    };

    //Para recibir los datos desde el reloj
    @Override
    public void onDataChanged(DataEventBuffer dataEvents) {
        Log.d("sendData()", "data changeeed22");
        fin_recepcion=false;
        for (DataEvent event : dataEvents) {
            if (event.getType() == DataEvent.TYPE_CHANGED) {
                // DataItem changed
                DataItem item = event.getDataItem();
                if (item.getUri().getPath().compareTo("/count") == 0) {
                    DataMap dataMap = DataMapItem.fromDataItem(item).getDataMap();
                    String a=dataMap.getString("clave1").split("///")[1]; //Para eliminar las barras

                    Log.d("sendData(heart)", dataMap.getString("clave2").split("///").length+"");

                    //Para recibir el fichero del pulso completo
                    if(dataMap.getString("clave2").split("///").length > 1) { //Si el fichero recibido tiene datos


                        String b = dataMap.getString("clave2").split("&")[1]; //Para eliminar las barras
                        grabarEnFichero(a, dataMap.getString("clave2"));
                    }

                    progreso++;
                    progressBar.setProgress(progreso);
                    double p=(progreso/15.0)*100;
                    tProgreso.setText(String.format("%.1f",p)+"%");
                    //Para saber si todos los datos se han recibido
                    String c=dataMap.getString("clave3").split("///")[1];
                    if(c.equals("FIN")){
                        fin_recepcion=true;
                        tProgreso.setText("100,0%");
                        progressBar.setProgress(15);
                        obtenerMedias();
                        pintarGrafico();

                        Toast.makeText(getActivity().getApplicationContext(),
                                "DATOS DEL RELOJ RECIBIDOS CORRECTAMENTE", Toast.LENGTH_SHORT).show();
                    }

                }
            } else if (event.getType() == DataEvent.TYPE_DELETED) {
                // DataItem deleted
            }
        }
    }

    public void onClickBLeer(View view) {
        leerFichero("ActividadR_Apr_06_2020.txt");
    }
    public void onClickBPintar(View view) {
        obtenerMedias();
        pintarGrafico();

    }
    public void onClickBSolicitar(View view){
        progreso=0;
        progressBar.setProgress(progreso);
        tProgreso.setText("0,0%");
        solicitarDatosPulso();


    }

    //Se solicitan al reloj los registros de los últimos 15 dias.
    public void solicitarDatosPulso() {
        new Thread(new Runnable() {
            @Override
            public void run() {

                CapabilityInfo capabilityInfo = null;
                try {
                    capabilityInfo = Tasks.await(
                            Wearable.getCapabilityClient(getActivity().getApplicationContext()).getCapability(
                                    "pulso", CapabilityClient.FILTER_REACHABLE));
                } catch (ExecutionException e) {
                    e.printStackTrace();
                } catch (InterruptedException e) {
                    e.printStackTrace();
                }

                String transcriptionNodeId = null;
                Set<Node> connectedNodes = capabilityInfo.getNodes();
                for (Node node : connectedNodes) {
                    transcriptionNodeId=node.getId();
                    break;
                }
                byte[] solicitar={0x01};
                if (transcriptionNodeId != null) {
                    Task<Integer> sendTask =
                            Wearable.getMessageClient(getActivity().getApplicationContext()).sendMessage(
                                    transcriptionNodeId, "pulso", solicitar);
                    sendTask.addOnSuccessListener(
                            new OnSuccessListener<Integer>() {
                                @Override
                                public void onSuccess(Integer integer) {
                                    Log.d("sendTask()", "Sending task was successful: " +integer);
                                }
                            });
                }
                else{
                    Log.d("sendTask()", "TranscriptionNode es nulo");
                }
            }
        }).start();
    }

    //Se obtienen los pulsos medios de los ultimos 15 dias para mostrarlos en el grafico
    public void obtenerMedias(){
        Log.d("OBTENER MEDIAS","OBTENER MEDIAS");
        long milis_dia=24*60*60*1000;
        medias_pulso.clear();
        Date d=new Date(System.currentTimeMillis()-milis_dia*15);
        boolean encontrado=false; //Variable para detectar si faltan datos en algun dia intermedio
        double media=0;

        for (int i=14;i>=0;i--) { //Para los ultimos 15 dias
            d=new Date(System.currentTimeMillis()-milis_dia*i);
            String[] a=d.toString().split(" ");


            try {

                InputStream inputStream = getActivity().openFileInput("ActividadR_"+a[1]+"_"+a[2]+"_"+a[5]+".txt");
                if(encontrado==false){
                    primer_dia_grafico=d;
                }
                encontrado=true;

                if (inputStream != null) {
                    InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
                    BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                    String receiveString = "";
                    ArrayList<Double> pulsos_dia = new ArrayList();
                    double suma=0;
                    int contador=0;

                    while ((receiveString = bufferedReader.readLine()) != null) {
                        String[] linea = receiveString.split("&");
                        Double pulso=Double.parseDouble(linea[1]);
                        if(pulso!=0){ //Para eliminar valores de 0 que devuelve a veces la pulsera
                            suma=suma+pulso;
                            contador++;
                        }
                    }
                    media=suma/contador;
                    Map.Entry<String,Double> entrada= new AbstractMap.SimpleEntry<String, Double>(a[1]+"_"+a[2],media);
                    medias_pulso.add(entrada);
                }
            } catch (FileNotFoundException e) {
                Log.e("login activity", "File not found: " + e.toString());
                if(encontrado==true){//Faltan datos en un dia intermedio
                    Map.Entry<String,Double> entrada= new AbstractMap.SimpleEntry<String, Double>(a[1]+"_"+a[2],media);
                    medias_pulso.add(entrada);
                }
            } catch (IOException e) {
                Log.e("login activity", "Can not read file: " + e.toString());
            }
        }
        for (int i=0;i<medias_pulso.size();i++){
            Log.d("mediasPulso",medias_pulso.get(i).getKey()+"xxx"+medias_pulso.get(i).getValue());
        }


    }



    public void pintarGrafico(){
        Log.d("PINTAR GRAFICO","PINTAR GRAFICO");

        ArrayList<Entry> incomeEntries = new ArrayList<>();

        for(int i=0;i<medias_pulso.size();i++){
            incomeEntries.add(new Entry(i,Math.round(medias_pulso.get(i).getValue())));

        }

        ArrayList<ILineDataSet> dataSets = new ArrayList<>();
        List<String> xAxisValues = new ArrayList<>();
        for(int i=0;i<medias_pulso.size();i++){
            xAxisValues.add(medias_pulso.get(i).getKey());
        }

        dataSets = new ArrayList<>();
        LineDataSet set1;

        set1 = new LineDataSet(incomeEntries, "Income");
        set1.setColor(Color.RED);
        set1.setValueTextColor(Color.BLACK);
        set1.setValueTextSize(10f);
        set1.setCircleColor(Color.RED);
        set1.setMode(LineDataSet.Mode.LINEAR);
        dataSets.add(set1);

        lineChart.setTouchEnabled(true);
        lineChart.setDragEnabled(true);
        lineChart.setScaleEnabled(false);
        lineChart.setPinchZoom(false);
        lineChart.setDrawGridBackground(false);

        lineChart.getXAxis().setDrawGridLines(false);
        lineChart.getAxisLeft().setDrawGridLines(false);
        lineChart.getAxisRight().setDrawGridLines(false);


        YAxis rightYAxis = lineChart.getAxisRight();
        rightYAxis.setEnabled(false);
        YAxis leftYAxis = lineChart.getAxisLeft();
        leftYAxis.setEnabled(true);
        XAxis topXAxis = lineChart.getXAxis();
        topXAxis.setEnabled(false);


        XAxis xAxis = lineChart.getXAxis();
        xAxis.setGranularity(1f);
        //xAxis.setCenterAxisLabels(true);
        xAxis.setEnabled(true);
        xAxis.setDrawGridLines(false);
        xAxis.setPosition(XAxis.XAxisPosition.BOTTOM);
        xAxis.setLabelRotationAngle(0f);
        xAxis.setDrawAxisLine(true);
        xAxis.setSpaceMin(0.4f);

        set1.setLineWidth(2f);
        set1.setCircleRadius(3f);
        set1.setDrawValues(true);

        lineChart.getXAxis().setValueFormatter(new com.github.mikephil.charting.formatter.IndexAxisValueFormatter(xAxisValues));

        LineData data = new LineData(dataSets);
        lineChart.setData(data);
        lineChart.animateX(2000);
        lineChart.invalidate();
        lineChart.getLegend().setEnabled(false);
        lineChart.getDescription().setEnabled(false);

    }
    public void agregarCabecera(int recursocabecera)
    {
        TableRow.LayoutParams layoutCelda;
        TableRow fila = new TableRow(getActivity());
        TableRow.LayoutParams layoutFila = new TableRow.LayoutParams(TableRow.LayoutParams.MATCH_PARENT, TableRow.LayoutParams.MATCH_PARENT);
        fila.setLayoutParams(layoutFila);

        String[] arraycabecera = rs.getStringArray(recursocabecera);
        COLUMNAS = arraycabecera.length;

        for(int i = 0; i < arraycabecera.length; i++)
        {
            TextView texto = new TextView(getActivity());
            layoutCelda = new TableRow.LayoutParams( TableRow.LayoutParams.MATCH_PARENT);
            texto.setText(arraycabecera[i]);
            texto.setGravity(Gravity.CENTER_HORIZONTAL);
            texto.setTypeface(texto.getTypeface(),Typeface.BOLD);
            texto.setTextColor(Color.BLACK);

            texto.setBackgroundResource(R.drawable.cabecera_tabla);
            texto.setLayoutParams(layoutCelda);

            fila.addView(texto);
        }

        tabla.addView(fila);
        filas.add(fila);

        FILAS++;
    }
    public void agregarFilaTabla(ArrayList<String> elementos)
    {
        TableRow.LayoutParams layoutCelda;
        TableRow.LayoutParams layoutFila = new TableRow.LayoutParams(TableRow.LayoutParams.MATCH_PARENT, TableRow.LayoutParams.MATCH_PARENT);
        TableRow fila = new TableRow(getActivity());
        fila.setLayoutParams(layoutFila);

        for(int i = 0; i< elementos.size(); i++)
        {
            TextView texto = new TextView(getActivity());
            texto.setText(String.valueOf(elementos.get(i)));
            texto.setGravity(Gravity.CENTER_HORIZONTAL);
            if(i==0){
                texto.setTypeface(texto.getTypeface(),Typeface.BOLD);
            }
            texto.setBackgroundResource(R.drawable.celda_tabla);
            layoutCelda = new TableRow.LayoutParams(TableLayout.LayoutParams.FILL_PARENT, TableRow.LayoutParams.MATCH_PARENT);
            texto.setLayoutParams(layoutCelda);

            fila.addView(texto);
        }

        tabla.addView(fila);
        filas.add(fila);

        FILAS++;
    }
    public void borrarDatosTabla()
    {
        tabla.removeViews(1,4);
        filas.remove(4);
        filas.remove(3);
        filas.remove(2);
        filas.remove(1);
        FILAS=1;

    }

    private int obtenerAnchoPixelesTexto(String texto)
    {
        Paint p = new Paint();
        Rect bounds = new Rect();
        p.setTextSize(60);

        p.getTextBounds(texto, 0, texto.length(), bounds);
        return bounds.width();
    }


    public void actualizarTabla(double pm0,double pmin0,double pmax0,double pm1,double pmin1,double pmax1,
                                double pm2,double pmin2,double pmax2, double pm3,double pmin3,double pmax3){
        DecimalFormat df = new DecimalFormat("#.00");
        borrarDatosTabla();

        ArrayList<String> elementos = new ArrayList<String>();
        elementos.add("Sueño");
        if(pm0!=pm0){
            elementos.add("Sin datos");
            elementos.add("Sin datos");
            elementos.add("Sin datos");
        }else{
            elementos.add(df.format(pm0)+"");
            elementos.add(pmin0+"");
            elementos.add(pmax0+"");
        }
        agregarFilaTabla(elementos);
        elementos.clear();

        elementos.add("Reposo");
        if(pm1!=pm1){
            elementos.add("Sin datos");
            elementos.add("Sin datos");
            elementos.add("Sin datos");
        }else{
            elementos.add(df.format(pm1)+"");
            elementos.add(pmin1+"");
            elementos.add(pmax1+"");
        }
        agregarFilaTabla(elementos);
        elementos.clear();

        elementos.add("Moderada");
        if(pm2!=pm2){
            elementos.add("Sin datos");
            elementos.add("Sin datos");
            elementos.add("Sin datos");
        }else{
            elementos.add(df.format(pm2)+"");
            elementos.add(pmin2+"");
            elementos.add(pmax2+"");
        }
        agregarFilaTabla(elementos);
        elementos.clear();

        elementos.add("Intensa");
        if(pm3!=pm3){
            elementos.add("Sin datos");
            elementos.add("Sin datos");
            elementos.add("Sin datos");
        }else{
            elementos.add(df.format(pm3)+"");
            elementos.add(pmin3+"");
            elementos.add(pmax3+"");
        }
        agregarFilaTabla(elementos);
        elementos.clear();

    }

    public void grabarEnFichero(String nombre, String data){

        FileOutputStream fou = null;
        try {
            fou = getActivity().getApplicationContext().openFileOutput(nombre, Context.MODE_PRIVATE); //Se sobreescriben los ficheros
            Log.d("grabarFichero()","private");
        } catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(fou);
        try {
            outputStreamWriter.append(data);
            outputStreamWriter.close();
        } catch (IOException e) {
            e.printStackTrace();
        }
    }
    public void leerFichero(String nombre){
        try {
            InputStream inputStream = getActivity().openFileInput(nombre);

            if (inputStream != null) {
                InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
                BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                String receiveString = "";

                while ((receiveString = bufferedReader.readLine()) != null) {
                    Log.d("leerFichero",receiveString);
                }
                inputStream.close();
            }
        } catch (FileNotFoundException e) {
            Log.e("login activity", "File not found: " + e.toString());
        } catch (IOException e) {
            Log.e("login activity", "Can not read file: " + e.toString());
        }

        Date d=new Date(System.currentTimeMillis());
        String[] a=d.toString().split(" ");
        Log.d("yyyyy",a[1]+"_"+a[2]+"_"+a[5]);
    }


}
