package es.uniovi.healthappv2;

import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.Service;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.Color;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.media.RingtoneManager;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.PowerManager;
import android.os.SystemClock;
import android.os.Vibrator;
import android.util.Log;
import android.widget.TextView;

import androidx.annotation.Nullable;
import androidx.core.app.NotificationCompat;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;

public class LocalService extends Service implements SensorEventListener{

    private TextView pulso;


    List<Sensor> listaSensores2;
    SensorManager sensorManager;
    Sensor sHeart;
    Sensor sAccelerometer;
    Sensor sGyroscpe;
    Sensor sSteps;

    ArrayList<String> datos_pulso;
    ArrayList<String> datos_acc;
    ArrayList<String> datos_gyr;

    float pasos;
    long tiempo_ms;
    String pasos_proc;
    String s;

    //Variables para detectar anomalías en el pulso
    double ext_inf_0;
    double ext_sup_0;
    double ext_inf_1;
    double ext_sup_1;
    double ext_inf_2;
    double ext_sup_2;
    double ext_inf_3;
    double ext_sup_3;
    int act_rangos=0;


    ArrayList<String> proc_actividad;

    //Para procesos ventana
    ArrayList<String> proc_acc;
    ArrayList<String> proc_gyr;
    ArrayList<String> proc_glob;

    ArrayList<Map.Entry<Long,String>> historial;

    //Variables que indican si se ha superado el proceso de calibracion de cada actividad.
    boolean calibracion[];
    int count_0;
    int count_1;
    int count_2;
    int count_3;

    int edad;
    double fcReposo;
    int MAX_CALIBRACION=100;

    double count_sleeping=0;

    double fuera_rango_0=0;
    double fuera_rango_1=0;
    double fuera_rango_2=0;
    double fuera_rango_3=0;

    public void onCreate()
    {

        super.onCreate();

        pasos=0;
        tiempo_ms=SystemClock.elapsedRealtime();
        pasos_proc="";
        s="";



        sensorManager= (SensorManager) getApplicationContext().getSystemService(this.SENSOR_SERVICE);
        if(sensorManager==null){
            Log.d("setAlarm()-Alarm","SensorManager es nulo");
        }
        listaSensores2 = sensorManager.getSensorList(Sensor.TYPE_HEART_RATE);
        if (!listaSensores2.isEmpty()) {
            System.out.println("Entra heart");
            sHeart = listaSensores2.get(0);
        }
        listaSensores2 = sensorManager.getSensorList(Sensor.TYPE_ACCELEROMETER);
        if (!listaSensores2.isEmpty()) {
            System.out.println("Entra accel");
            sAccelerometer = listaSensores2.get(0);
        }
        listaSensores2 = sensorManager.getSensorList(Sensor.TYPE_GYROSCOPE);
        if (!listaSensores2.isEmpty()) {
            System.out.println("Entra gyro");
            sGyroscpe = listaSensores2.get(0);
        }
        listaSensores2 = sensorManager.getSensorList(Sensor.TYPE_STEP_COUNTER);
        if (!listaSensores2.isEmpty()) {
            System.out.println("Entra steps");
            sSteps = listaSensores2.get(0);
        }

        proc_actividad=new ArrayList<>();

        proc_acc=new ArrayList<>();
        proc_gyr=new ArrayList<>();
        proc_glob=new ArrayList<>();

        historial=new ArrayList<>();

        calibracion=new boolean[]{true,true,true,true};


        String e=leerFichero("Edad.txt");
        if(e!=""){
            edad=Integer.parseInt(e.split("\n")[0]);
        }

        String pulso=leerFichero("PulsoCalibrado.txt");
        if(pulso!=""){
            fcReposo=Double.parseDouble(pulso);
        }

        String count=leerFichero("ContadoresCalibracion.txt");
        if(count!=""){
            count_0=Integer.valueOf(count.split("&")[0]);
            count_1=Integer.valueOf(count.split("&")[1]);
            count_2=Integer.valueOf(count.split("&")[2]);
            count_3=Integer.valueOf(count.split("&")[3]);
        }
        else{
            count_0=0;
            count_1=0;
            count_2=0;
            count_2=0;
        }
        if(count_0>MAX_CALIBRACION){
            calibracion[0]=false;
        }
        if(count_1>MAX_CALIBRACION){
            calibracion[1]=false;
        }
        if(count_2>MAX_CALIBRACION){
            calibracion[2]=false;
        }
        if(count_3>MAX_CALIBRACION){
            calibracion[3]=false;
        }
    }

    @Override
    public int onStartCommand(Intent intent, int flags, int startId) {

        //Al ser un servicio en segundo plano hay que mostrar notificacion para informar a usuario
        if (Build.VERSION.SDK_INT >= 26) {

            String NOTIFICATION_CHANNEL_ID = "pl.***.***";
            String channelName = "Communication Service";
            NotificationChannel chan = new NotificationChannel(NOTIFICATION_CHANNEL_ID, channelName, NotificationManager.IMPORTANCE_HIGH);
            chan.setLightColor(Color.BLUE);
            chan.setLockscreenVisibility(Notification.VISIBILITY_PRIVATE);

            NotificationManager manager = (NotificationManager) getSystemService(Context.NOTIFICATION_SERVICE);
            assert manager != null;
            manager.createNotificationChannel(chan);

            NotificationCompat.Builder notificationBuilder = new NotificationCompat.Builder(this,NOTIFICATION_CHANNEL_ID);
            Notification notification = notificationBuilder.setOngoing(true)
                    .setContentTitle(this.getString(R.string.app_name))
                    .setPriority(NotificationManager.IMPORTANCE_HIGH)
                    .setCategory(Notification.CATEGORY_SERVICE)
                    .build();
            startForeground(4, notification);
        } else {
            startForeground(3, new Notification());
        }


        //Se añade el listener para el broadcast que es enviado desde Alarm para indicar que se debe iniciar la medicion
        LocalBroadcastManager.getInstance(this).registerReceiver(
                mMessageReceiver, new IntentFilter("Medir"));


        obtenerRangosPulso();

        return START_STICKY;
    }

    //Receptor del broadcast desde Alarm. Se deeb iniciar la medicion
    private BroadcastReceiver mMessageReceiver = new BroadcastReceiver() {
        @Override
        public void onReceive(Context context, Intent intent) {

            double datos_recibidos=intent.getDoubleExtra("Mide",0);
            if(datos_recibidos==1.0){
                medir();
            }
            if(datos_recibidos==2.0){
                calibrar();
            }
            if(datos_recibidos==3.0){
                obtenerRangosPulso();
            }
        }
    };


    @Nullable
    @Override
    public IBinder onBind(Intent intent) {
        return null;
    }

    //Durante 5 min se recogen datos del pulso para obtener su frecuencia en reposo
    public void calibrar(){
        final SensorEventListener l=this;
        Log.d("calibrar","ini calibracion");
        new Thread(){
            @Override
            public void run() {


                    //Se despierta la CPU para que los sensores puedan proporcionar los datos
                    PowerManager pm = (PowerManager) getSystemService(Context.POWER_SERVICE);
                    PowerManager.WakeLock wl = pm.newWakeLock(PowerManager.ACQUIRE_CAUSES_WAKEUP | PowerManager.PARTIAL_WAKE_LOCK, "WatchApp:wake");
                    wl.acquire(5 * 60 * 1000 + 2);

                    //Se vacían los arrys que continen los datos de los sensores
                    datos_pulso = new ArrayList<>();

                    //Para poder invocar al listener definido en este servicio
                    HandlerThread mHandlerThread = new HandlerThread("sensorThread");
                    mHandlerThread.start();
                    Handler handler = new Handler(mHandlerThread.getLooper());

                    //Se registra el pulsometro, acelerometro y giroscopio
                    boolean sensorRegistered = sensorManager.registerListener(l, sHeart, SensorManager.SENSOR_DELAY_FASTEST, handler);
                    Log.d("Sensor Status:", " Sensor registered:(heart) " + (sensorRegistered ? "yes" : "no") + sHeart.getName());

                    try {
                        Thread.sleep(5 * 60 * 1000);
                    } catch (InterruptedException e) {
                        e.printStackTrace();
                    }

                    sensorManager.unregisterListener(l, sHeart);

                    //Se elimina el manejador
                    mHandlerThread.quit();

                    double min=300;
                    ArrayList<Double> datos=new ArrayList<>();
                    for (int i=0;i<datos_pulso.size();i++){
                        if(Double.parseDouble(datos_pulso.get(i))<min){
                            min=Double.parseDouble(datos_pulso.get(i));
                        }

                    }

                    escribirEnFicheroP("PulsoCalibrado.txt",min+"");
                    generarNotificacion("Calibración finalizada");
                    sendMessageToActivity("CalibracionFinalizada");
                    obtenerRangosPulso();
                }
            }.start();
    }

    //Proceso de medicion.
    //Dura 18s aprox
    //Durante los primeros 8s se recogen datos de acelerometro y giroscopio.
    //Durante los siguientes 10s se toman datos del ritmo cardiaco.
    //Los datos de acc y gyr se procesan en ventanas de 2s con 50% de solapamiento para detectar la actividad
    public void medir(){

        Log.d("LOCALSERVICEPULSO","["+ext_inf_0+","+ext_sup_0+"]"+"["+ext_inf_1+","+ext_sup_1+"]"+"["+ext_inf_2+","+ext_sup_2+"]"+"["+ext_inf_3+","+ext_sup_3+"]");

        final SensorEventListener l=this;
        new Thread(){
            @Override
            public void run() {

                    //Se despierta la CPU para que los sensores puedan proporcionar los datos
                    PowerManager pm = (PowerManager) getSystemService(Context.POWER_SERVICE);
                    PowerManager.WakeLock wl = pm.newWakeLock(PowerManager.ACQUIRE_CAUSES_WAKEUP | PowerManager.PARTIAL_WAKE_LOCK, "WatchApp:wake");
                    wl.acquire(21 * 1000);

                    //Se vacían los arrys que continen los datos de los sensores
                    datos_pulso = new ArrayList<>();
                    datos_acc = new ArrayList<>();
                    //datos_gyr = new ArrayList<>();
                    proc_actividad.clear();

                    //Para poder invocar al listener definido en este servicio
                    HandlerThread mHandlerThread = new HandlerThread("sensorThread");
                    mHandlerThread.start();
                    Handler handler = new Handler(mHandlerThread.getLooper());

                    //Se registra el pulsometro, acelerometro. El giroscopio finalmente no se utiliza
                    boolean sensorRegistered = sensorManager.registerListener(l, sHeart, SensorManager.SENSOR_DELAY_FASTEST, handler);
                    Log.d("Sensor Status:", " Sensor registered:(heart) " + (sensorRegistered ? "yes" : "no") + sHeart.getName());

                    sensorRegistered = sensorManager.registerListener(l, sAccelerometer, SensorManager.SENSOR_DELAY_UI, handler);
                    Log.d("Sensor Status:", " Sensor registered:(acc) " + (sensorRegistered ? "yes" : "no") + sHeart.getName());


                    try {
                        Thread.sleep(8 * 1000);
                    } catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    sensorManager.unregisterListener(l, sAccelerometer);



                    try {
                        Thread.sleep(10 * 1000);
                    } catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    sensorManager.unregisterListener(l, sHeart);

                    //Se elimina el manejador
                    boolean b = mHandlerThread.quit();

                    Date d = new Date(System.currentTimeMillis());
                    String[] a = d.toString().split(" ");


                    double pulso = 0;
                    for (int i = 0; i < datos_pulso.size(); i++) {
                        if (Double.parseDouble(datos_pulso.get(i)) != 0) {
                            pulso = Double.parseDouble(datos_pulso.get(i));
                        }
                    }

                escribirEnFichero("Hora.txt",a[3]+"&"+pulso);



                    proc_acc.clear();
                    proc_glob.clear();


                    //Acelerometro

                    //Se calcula la frecuencia a la que se recogieron los datos
                    double frecuencia = datos_acc.size() / 8;
                    frecuencia = Math.floor(frecuencia);
                    int f = (int) frecuencia;
                    ArrayList<String> ventana = new ArrayList<>();
                    //Procesamiento en ventanas de 2s con 50% de solapamiento
                    for (int i = 0; i < Math.floor(datos_acc.size() / f) - 1; i++) {
                        ventana.clear();
                        for (int j = f * i; j < f * (i + 2); j++) {
                            ventana.add(datos_acc.get(j));
                        }
                        //proc_acc.add(procesar(ventana));
                        procesarAcelerometro(ventana);
                    }




        //Determinar la actividad depues de las actividades parciales de las ventanas
        int actividad=0;
        int actividad1=0;
        int actividad2=0;
        int actividad3=0;
        for (int i=0;i<proc_actividad.size();i++){
            Log.d("ACTIVIDAD PROCESADA",proc_actividad.get(i));
            if(proc_actividad.get(i).equals("1")){
                actividad1++;
            }
            else if(proc_actividad.get(i).equals("2")){
                actividad2++;
            }
            else{
                actividad3++;
            }
        }

        if(actividad3>actividad2 && actividad3>actividad1){
            actividad=3;
        }
        else if (actividad2>actividad3 && actividad2>actividad1){
            actividad=2;
        }
        else{
            actividad=1;
        }

        if(historial.size()>0){
                if(actividad==1){
                    count_sleeping=count_sleeping+((System.currentTimeMillis()/1000/60) - (historial.get(historial.size() - 1).getKey()/60));
                }
                else{
                    count_sleeping=0;
                }
            }
                int hora_actual=Integer.parseInt(a[3].split(":")[0]);

                    if (count_sleeping > 30 && hora_actual >= 0 && hora_actual < 8) {
                        actividad=0;
                }


                act_rangos++;
                if(act_rangos>=50){
                    obtenerRangosPulso();
                    act_rangos=0;
                }


        if(historial.size()==3){
            historial.remove(0);
            historial.add(new AbstractMap.SimpleEntry<Long, String>(System.currentTimeMillis()/1000,String.valueOf(pulso)+"&"+actividad));
        }
        else{
            historial.add(new AbstractMap.SimpleEntry<Long, String>(System.currentTimeMillis()/1000,String.valueOf(pulso)+"&"+actividad));
        }

                if(pulso>220-edad){
                    generarNotificacion("FC máxima superada ("+pulso+"PPM)");
                }
                if (pulso<40 && pulso!=0){
                    generarNotificacion("FC muy baja ("+pulso+"PPM)");
                }
                String salida="";
                if(actividad==0){
                    salida="Sueño";
                }
                else if(actividad==1){
                    salida="Reposo";
                }
                else if(actividad==2){
                    salida="Moderado";
                }
                else{
                    salida="Intenso";
                }

        if(pulso==0){
            sendMessageToActivity(pulso+"PPM ("+salida+")");
            return;
        }



        //La actividad se encuentra en fase de calibracion
        if(calibracion[actividad]){
            if(historial.size()==3){

                long intervalo = historial.get(historial.size() - 1).getKey() - historial.get(historial.size() - 2).getKey();
                long intervalo2 = historial.get(historial.size() - 1).getKey() - historial.get(historial.size() - 3).getKey();
                Log.d("INTERVALO1",intervalo+"");
                Log.d("INTERVALO2",intervalo2+"");


                //Medicion cada minuto
                if(intervalo < 70 && intervalo > 50 && intervalo2 < 130 && intervalo2 > 110){

                    //La actividad actual tiene que ser igual que las 2 anteriores
                    if (actividad==Integer.valueOf(historial.get(historial.size() - 2).getValue().split("&")[1]) &&
                            actividad==Integer.valueOf(historial.get(historial.size() - 3).getValue().split("&")[1])){

                        gestionarCalibracion(actividad, pulso);
                    }
                }
                //Medición cada 2min
                else if(intervalo < 130 && intervalo > 110){

                    //La actividad actual tiene que ser igual que la anterior
                    if (actividad==Integer.valueOf(historial.get(historial.size() - 2).getValue().split("&")[1])){

                        gestionarCalibracion(actividad, pulso);
                    }
                }
                //Si el intervalo de medicion es mayor de 2 min no vale para calibracion
            }
        }

        //La actividad no se encuentra en calibración
        else{
            Log.d("NO CALIBRACION","NO CALIBRACION");


            if(historial.size()==3){
                double pulso_anterior = Double.parseDouble(historial.get(historial.size() - 2).getValue().split("&")[0]);
                double pulso_anterior2 = Double.parseDouble(historial.get(historial.size() - 3).getValue().split("&")[0]);

                long intervalo = historial.get(historial.size() - 1).getKey() - historial.get(historial.size() - 2).getKey();
                long intervalo2 = historial.get(historial.size() - 1).getKey() - historial.get(historial.size() - 3).getKey();

                Log.d("INTERVALO1",intervalo+"");
                Log.d("INTERVALO2",intervalo2+"");
                //Si la medicion es cada minuto
                if(intervalo <= 70 && intervalo >= 50 && intervalo2 <= 130 && intervalo2 >= 110){

                    Log.d("MEDICION CADA MIN", "CADA MIN");

                    //Salto de actividad entre el min actual y el anterior y recuperacion mala. Si el pulso anterior es 0 por una mala medicion no se notifica.
                    //Se requiere que dos minutos antes tambien esté realizando una mayor actividad para que sea una actividad mas consolidada.
                    //Para la actividad sueño no se considera mala recuperacion
                    if(actividad < Integer.valueOf(historial.get(historial.size() - 2).getValue().split("&")[1]) && pulso>pulso_anterior-11 &&
                            actividad < Integer.valueOf(historial.get(historial.size() - 3).getValue().split("&")[1])&& pulso_anterior!=0 && actividad!=0){
                        generarNotificacion("Recuperación de la FC anormal");
                        Log.d("MALA RECU","MALA RECU1");
                    }

                    //Mala recuperación entre el min actual y el 2 min antes. Si el pulso anterior es 0 por una mala medicion no se notifica. En el miuto intermedio, la actividad tambien tiene que ser menor que el minuto anterior.
                    else if(actividad < Integer.valueOf(historial.get(historial.size() - 3).getValue().split("&")[1]) && pulso>pulso_anterior2-21 &&
                            Integer.valueOf(historial.get(historial.size() - 2).getValue().split("&")[1]) < Integer.valueOf(historial.get(historial.size() - 3).getValue().split("&")[1])
                            && pulso_anterior2!=0 && actividad!=0){
                        generarNotificacion("Recuperación de la FC anormal");
                        Log.d("MALA RECU","MALA RECU2");
                    }

                    //La actividad actual es la misma que 2 min antes, se mira si está dentro de rango y se anota. Fuera de rango -> Alerta
                    else if(actividad==Integer.valueOf(historial.get(historial.size() - 2).getValue().split("&")[1])  &&
                             actividad==Integer.valueOf(historial.get(historial.size() - 3).getValue().split("&")[1])){
                        Log.d("LLAMADO A GESTIONAR", "GESTIONAR");
                        gestionarPulsoActividad(actividad,pulso, intervalo);
                    }
                }

                //Si la medicion es cada 2 minutos
                else if(intervalo <= 130 && intervalo >= 110){

                    //Salto de actividad entre el momento actual y 2 min antes y mala recuperacion
                    if(actividad < Integer.valueOf(historial.get(historial.size() - 2).getValue().split("&")[1]) && pulso>pulso_anterior-21 && pulso_anterior!=0 && actividad!=0){
                        generarNotificacion("Recuperación de la FC anormal");
                        Log.d("MALA RECU","MALA RECU2min");
                    }

                    //Actividad actual es la misma que hace 2 min
                    else if(actividad==Integer.valueOf(historial.get(historial.size() - 2).getValue().split("&")[1])  &&
                            actividad==Integer.valueOf(historial.get(historial.size() - 3).getValue().split("&")[1])){

                        gestionarPulsoActividad(actividad,pulso, intervalo);
                    }


                }

                //Mediciones cada mas tiempo, no se tienen en cuenta actividades anteriores por su lejanía en el tiempo
                else if(intervalo>130){
                    gestionarPulsoActividad(actividad,pulso, intervalo);

                }
            }

        }
                sendMessageToActivity(pulso+"PPM ("+salida+")");

        Log.d("FIN MEDICION","FIN MEDICION");
                }
            }.start();
    }


    public void gestionarPulsoActividad(int actividad, double pulso, long intervalo){

        Date d = new Date(System.currentTimeMillis());
        String[] a = d.toString().split(" ");

        Log.d("GESTIONARPULSOACT", "INICIO");

        if(actividad==0){
            if(pulso<ext_inf_0 || pulso>ext_sup_0){
                fuera_rango_0=fuera_rango_0+intervalo;
                if(fuera_rango_0>=10*60){
                    generarNotificacion("FC anormal durante el Sueño ("+pulso+"PPM)");
                }

                escribirEnFichero("ActividadR_"+a[1]+"_"+a[2]+"_"+a[5]+".txt",a[3]+"&"+pulso+"&"+actividad+"&");
                return;
            }
        }
        if(actividad==1){
            if(pulso<ext_inf_1 || pulso>ext_sup_1){

                fuera_rango_1=fuera_rango_1+intervalo;
                if(fuera_rango_1>=10*60){
                    generarNotificacion("FC anormal durante el Reposo ("+pulso+"PPM)");
                }

                escribirEnFichero("ActividadR_"+a[1]+"_"+a[2]+"_"+a[5]+".txt",a[3]+"&"+pulso+"&"+actividad+"&");
                return;
            }
        }
        if(actividad==2){
            if(pulso<ext_inf_2 || pulso>ext_sup_2){
                fuera_rango_2=fuera_rango_2+intervalo;
                if(fuera_rango_2>=6*60){
                    generarNotificacion("FC anormal durante la actividad Moderada ("+pulso+"PPM)");
                }

                escribirEnFichero("ActividadR_"+a[1]+"_"+a[2]+"_"+a[5]+".txt",a[3]+"&"+pulso+"&"+actividad+"&");
                return;
            }
        }
        if(actividad==3){
            if(pulso<ext_inf_3 || pulso>ext_sup_3){
                fuera_rango_3=fuera_rango_3+intervalo;
                if(fuera_rango_3>=4*60){
                    generarNotificacion("FC anormal durante la actividad Intensa ("+pulso+"PPM)");
                }

                escribirEnFichero("ActividadR_"+a[1]+"_"+a[2]+"_"+a[5]+".txt",a[3]+"&"+pulso+"&"+actividad+"&");
                return;
            }
        }

        fuera_rango_0=0;
        fuera_rango_1=0;
        fuera_rango_2=0;
        fuera_rango_3=0;
        escribirEnFichero("ActividadR_"+a[1]+"_"+a[2]+"_"+a[5]+".txt",a[3]+"&"+pulso+"&"+actividad+"&");

        Log.d("GESTIONARPULSOACT", "ESCRITO");


    }

    public void gestionarCalibracion(int actividad, double pulso){

        Date d = new Date(System.currentTimeMillis());
        String[] a = d.toString().split(" ");

        //Para la actividad de reposo se impone la restriccion de la fcReposo
        if(actividad==0 && pulso <= 100 && pulso >= 40){
            escribirEnFichero("ActividadR_"+a[1]+"_"+a[2]+"_"+a[5]+".txt",a[3]+"&"+pulso+"&"+actividad+"&");
            count_0++;
            escribirEnFicheroP("ContadoresCalibracion.txt", count_0+"&"+count_1+"&"+count_2+"&"+count_3+"&");
            if(count_0>MAX_CALIBRACION){
                calibracion[actividad]=false;
                obtenerRangosPulso();
            }
        }
        //Para el resto de actividades se guarda directamente
        else if(actividad==1 && pulso <= 100 && pulso >= fcReposo){
            escribirEnFichero("ActividadR_"+a[1]+"_"+a[2]+"_"+a[5]+".txt",a[3]+"&"+pulso+"&"+actividad+"&");
            count_1++;
            escribirEnFicheroP("ContadoresCalibracion.txt", count_0+"&"+count_1+"&"+count_2+"&"+count_3+"&");
            if(count_1>MAX_CALIBRACION){
                calibracion[actividad]=false;
                obtenerRangosPulso();
            }
        }
        else if (actividad==2 && pulso <= 0.7*(220-edad) && pulso >= 0.5*(220-edad)){
            escribirEnFichero("ActividadR_"+a[1]+"_"+a[2]+"_"+a[5]+".txt",a[3]+"&"+pulso+"&"+actividad+"&");
            count_2++;
            escribirEnFicheroP("ContadoresCalibracion.txt", count_0+"&"+count_1+"&"+count_2+"&"+count_3+"&");
            if(count_2>MAX_CALIBRACION){
                calibracion[actividad]=false;
                obtenerRangosPulso();
            }
        }
        else if (actividad==3 && pulso <= 0.9*(220-edad) && pulso >= 0.7*(220-edad)){
            escribirEnFichero("ActividadR_"+a[1]+"_"+a[2]+"_"+a[5]+".txt",a[3]+"&"+pulso+"&"+actividad+"&");
            count_3++;
            escribirEnFicheroP("ContadoresCalibracion.txt", count_0+"&"+count_1+"&"+count_2+"&"+count_3+"&");
            if(count_3>MAX_CALIBRACION){
                calibracion[actividad]=false;
                obtenerRangosPulso();
            }
        }

    }

    //Se porcesan los datos del acelerometro
    public void procesarAcelerometro(ArrayList<String> datos){

        ArrayList<Double> vectores_mag=new ArrayList<>();

        double dx=0;
        double dy=0;
        double dz=0;

        for(int i=0;i<datos.size();i++) {
            String actual = datos.get(i);
            String[] s=actual.split("&");
            String x=s[0];
            String y=s[1];
            String z=s[2];

            Double vect_mag=Math.sqrt(Math.pow(Double.parseDouble(x),2)+Math.pow(Double.parseDouble(y),2)+Math.pow(Double.parseDouble(z),2));
            vectores_mag.add(vect_mag);
        }
        //Media
        double suma_media=0;
        for (int i=0;i<vectores_mag.size();i++){
            suma_media=suma_media+vectores_mag.get(i);
        }
        double media=suma_media/vectores_mag.size();
        //Desviacion tipica

        double suma_desv=0;
        for(int i=0;i<vectores_mag.size();i++){
            suma_desv=suma_desv+Math.pow((vectores_mag.get(i)-media),2);
        }

        double desv=Math.sqrt(suma_desv/(vectores_mag.size()-1));
        Log.d("PROCESARACTIVIDAD",desv+"");



        //Rango intercuartílico
        Collections.sort(vectores_mag);
        int pos_cuartil1 = 0;
        int pos_cuartil2 = 0;
        double rango_intercuartil = 0;
        pos_cuartil1 = (int) Math.ceil(0.25 * vectores_mag.size()) - 1;
        pos_cuartil2 = (int) Math.ceil(0.75 * vectores_mag.size()) - 1;
        rango_intercuartil = vectores_mag.get(pos_cuartil2) - vectores_mag.get(pos_cuartil1);

        //Asimetría
        double suma_asim=0;
        for (int i=0;i<vectores_mag.size();i++){
            suma_asim=suma_asim+(Math.pow(vectores_mag.get(i)-media,3)/Math.pow(desv,3));
        }
        double dividendo=(vectores_mag.size()-1)*(vectores_mag.size()-2);
        double antes=vectores_mag.size()/dividendo;
        double asimetria=antes*suma_asim;

        //Implementación del árbol de decisión generado con sklearn
        if(rango_intercuartil<=5.865 && media<=10.099){
            proc_actividad.add("1");
        }
        else if(rango_intercuartil<=5.865 && media > 10.099){
            proc_actividad.add("2");
        }
        else if(rango_intercuartil>5.865 && asimetria>0.017){
            proc_actividad.add("3");
        }
        else if(rango_intercuartil<=5.865 && asimetria<=0.017){
            proc_actividad.add("2");
        }

    }



    public void generarNotificacion(String texto){
        NotificationCompat.Builder b = new NotificationCompat.Builder(this);

        NotificationChannel mChannel = null;
        b.setSmallIcon(R.drawable.ic_add_white_24dp)
                .setContentTitle("HealthApp")
                .setContentText(texto)
                .setPriority(NotificationCompat.PRIORITY_HIGH)
                .setSound(RingtoneManager.getDefaultUri(RingtoneManager.TYPE_NOTIFICATION))
                .setDefaults(Notification.DEFAULT_ALL)
                .setVibrate(new long[]{1000, 1000, 1000, 1000, 1000, 1000});

        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
            mChannel = new NotificationChannel("your-channel", "yourSubjectName", NotificationManager.IMPORTANCE_HIGH);
            b.setChannelId("your-channel");
        }

        NotificationManager notificationManager = (NotificationManager) getSystemService(Context.NOTIFICATION_SERVICE);
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
            notificationManager.createNotificationChannel(mChannel);
        }
        notificationManager.notify(1, b.build());

        Vibrator vibrator = (Vibrator) getSystemService(VIBRATOR_SERVICE);
        long[] newvibrationPattern = {0, 1000, 500, 50,
                0, 1000, 500, 50,
                0, 1000, 500, 50,
                0, 1000, 500, 50,
                0, 1000, 500, 50,
                0, 1000, 500, 50};
        final int indexInPatternToRepeat = -1;
        vibrator.vibrate(newvibrationPattern, indexInPatternToRepeat);
    }

    public void obtenerRangosPulso(){
        ArrayList<Double> pulsos_act0=new ArrayList<>();
        ArrayList<Double> pulsos_act1=new ArrayList<>();
        ArrayList<Double> pulsos_act2=new ArrayList<>();
        ArrayList<Double> pulsos_act3=new ArrayList<>();

        double suma_media_0=0;
        double contador_media_0=0;
        double suma_media_1=0;
        double contador_media_1=0;
        double suma_media_2=0;
        double contador_media_2=0;
        double suma_media_3=0;
        double contador_media_3=0;


        File f = new File(getFilesDir().toString());
        File[] files = f.listFiles();
        for(int i=0;i<files.length;i++){
            if(files[i].getName().length()>=11) {
                if (files[i].getName().substring(0, 11).equals("ActividadR_")) {

                    try {
                        InputStream inputStream = openFileInput(files[i].getName());

                        if (inputStream != null) {
                            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
                            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                            String receiveString = "";


                            while ((receiveString = bufferedReader.readLine()) != null) {
                                String[] s = receiveString.split("&");
                                if(Double.valueOf(s[1])!=0) {//Se descartan los valores de 0

                                    if (s[2].equals("0")) {
                                        pulsos_act0.add(Double.valueOf(s[1]));
                                        contador_media_0++;
                                        suma_media_0 = suma_media_0 + Double.valueOf(s[1]);
                                    } else if (s[2].equals("1")) {
                                        pulsos_act1.add(Double.valueOf(s[1]));
                                        contador_media_1++;
                                        suma_media_1 = suma_media_1 + Double.valueOf(s[1]);
                                    } else if (s[2].equals("2")) {
                                        pulsos_act2.add(Double.valueOf(s[1]));
                                        contador_media_2++;
                                        suma_media_2 = suma_media_2 + Double.valueOf(s[1]);
                                    } else if (s[2].equals("3")) {
                                        pulsos_act3.add(Double.valueOf(s[1]));
                                        contador_media_3++;
                                        suma_media_3 = suma_media_3 + Double.valueOf(s[1]);
                                    }

                                }
                            }
                            inputStream.close();
                        }
                    } catch (FileNotFoundException e) {
                        Log.e("login activity", "File not found: " + e.toString());
                    } catch (IOException e) {
                        Log.e("login activity", "Can not read file: " + e.toString());
                    }
                }
            }
        }//acaba for

        double media_0=suma_media_0/contador_media_0;
        double media_1=suma_media_1/contador_media_1;
        double media_2=suma_media_2/contador_media_2;
        double media_3=suma_media_3/contador_media_3;

        Collections.sort(pulsos_act0);
        Collections.sort(pulsos_act1);
        Collections.sort(pulsos_act2);
        Collections.sort(pulsos_act3);



        if(pulsos_act0.size()>0) {
            double suma_d0 = 0;
            for (int i = 0; i < pulsos_act0.size(); i++) {
                suma_d0 = suma_d0 + Math.pow((pulsos_act0.get(i) - media_0), 2);
            }
            double desv_0 = Math.sqrt(suma_d0 / (pulsos_act0.size() - 1));
            ext_inf_0 = media_0 - 1.5*desv_0;
            ext_sup_0 = media_0 + 1.5*desv_0;
        }

        if(pulsos_act1.size()>0) {
            double suma_d1 = 0;
            for (int i = 0; i < pulsos_act1.size(); i++) {
                suma_d1 = suma_d1 + Math.pow((pulsos_act1.get(i) - media_1), 2);
            }
            double desv_1 = Math.sqrt(suma_d1 / (pulsos_act1.size() - 1));
            ext_inf_1 = media_1 - 1.5*desv_1;
            ext_sup_1 = media_1 + 1.5*desv_1;
        }

        if(pulsos_act2.size()>0) {
            double suma_d2 = 0;
            for (int i = 0; i < pulsos_act2.size(); i++) {
                suma_d2 = suma_d2 + Math.pow((pulsos_act2.get(i) - media_2), 2);
            }
            double desv_2 = Math.sqrt(suma_d2 / (pulsos_act2.size() - 1));
            ext_inf_2 = media_2 - 1.5*desv_2;
            ext_sup_2 = media_2 + 1.5*desv_2;
        }

        if(pulsos_act3.size()>0) {
            double suma_d3 = 0;
            for (int i = 0; i < pulsos_act3.size(); i++) {
                suma_d3 = suma_d3 + Math.pow((pulsos_act3.get(i) - media_3), 2);
            }
            double desv_3 = Math.sqrt(suma_d3 / (pulsos_act3.size() - 1));
            ext_inf_3 = media_3 - 1.5*desv_3;
            ext_sup_3 = media_3 + 1.5*desv_3;
        }


        String e=leerFichero("Edad.txt");
        if(e!=""){
            edad=Integer.parseInt(e.split("\n")[0]);
        }
        String pulso=leerFichero("PulsoCalibrado.txt");
        if(pulso!=""){
            fcReposo=Double.parseDouble(pulso);
        }
        escribirEnFicheroP("RangosPulso.txt",ext_inf_0+"&"+ext_sup_0+"&"+ext_inf_1+"&"+ext_sup_1+"&"+ext_inf_2+"&"+ext_sup_2+"&"+ext_inf_3+"&"+ext_sup_3+"&");
    }



    public void escribirEnFichero(String filename, ArrayList<String> array){

        try {
            FileOutputStream fou = this.openFileOutput(filename, Context.MODE_APPEND);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(fou);
            for(int i=0;i<array.size();i++){
                //Log.d("escritooo","escritoooo");
                outputStreamWriter.append(array.get(i));
            }
            outputStreamWriter.close();
        }catch (IOException e) {
            Log.e("Exception", "File write failed: " + e.toString());
        }
    }
    public void escribirEnFicheroP(String filename, ArrayList<String> array){

        try {
            FileOutputStream fou = this.openFileOutput(filename, Context.MODE_PRIVATE);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(fou);
            for(int i=0;i<array.size();i++){
                //Log.d("escritooo","escritoooo");
                outputStreamWriter.append(array.get(i));
            }
            outputStreamWriter.close();
        }catch (IOException e) {
            Log.e("Exception", "File write failed: " + e.toString());
        }
    }

    public void escribirEnFichero(String filename, String datos){

        try {
            FileOutputStream fou = this.openFileOutput(filename, Context.MODE_APPEND);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(fou);
            outputStreamWriter.append(datos+"\n");
            outputStreamWriter.close();
        }catch (IOException e) {
            Log.e("Exception", "File write failed: " + e.toString());
        }
    }
    public void escribirEnFicheroP(String filename, String datos){

        try {
            FileOutputStream fou = this.openFileOutput(filename, Context.MODE_PRIVATE);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(fou);
            outputStreamWriter.write(datos+"\n");
            outputStreamWriter.close();
        }catch (IOException e) {
            Log.e("Exception", "File write failed: " + e.toString());
        }
    }
    public String leerFichero(String nombre){
        String fichero_leido="";
        try {
            InputStream inputStream = openFileInput(nombre);

            if (inputStream != null) {
                InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
                BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                String receiveString = "";

                while ((receiveString = bufferedReader.readLine()) != null) {
                    //Log.d("leerFichero",receiveString);
                    fichero_leido=fichero_leido+receiveString+"\n";
                }
                inputStream.close();
            }
        } catch (FileNotFoundException e) {
            Log.e("login activity", "File not found: " + e.toString());
        } catch (IOException e) {
            Log.e("login activity", "Can not read file: " + e.toString());
        }
        return fichero_leido;
    }

    private void sendMessageToActivity(String datos) {//Para enviar datos por broadcast y mostrar info en la interfaz
        Intent intent = new Intent("DatosInterfaz");
        // You can also include some extra data.
        intent.putExtra("Datos", datos);
        LocalBroadcastManager.getInstance(this).sendBroadcast(intent);
    }

    @Override
    public void onSensorChanged(SensorEvent evento) {

        Date d=new Date(System.currentTimeMillis());

        if(evento.sensor.getType()==Sensor.TYPE_HEART_RATE){
            datos_pulso.add(String.valueOf(evento.values[0]));
        }
        else if(evento.sensor.getType()==Sensor.TYPE_ACCELEROMETER){

            datos_acc.add(
                    String.valueOf(evento.values[0])+
                    "&"+String.valueOf(evento.values[1])+
                    "&"+String.valueOf(evento.values[2])+"\n");
        }
        else if(evento.sensor.getType()==Sensor.TYPE_GYROSCOPE){

            datos_gyr.add(
                    String.valueOf(evento.values[0])+
                            "&"+String.valueOf(evento.values[1])+
                            "&"+String.valueOf(evento.values[2])+"\n");
        }


    }

    @Override
    public void onAccuracyChanged(Sensor sensor, int accuracy) {

    }


}
