package es.uniovi.healthappv2;

import android.Manifest;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageManager;
import android.hardware.Sensor;
import android.hardware.SensorManager;
import android.os.Build;
import android.os.Bundle;
import android.support.wearable.activity.WearableActivity;
import android.util.Log;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.EditText;
import android.widget.Spinner;
import android.widget.TextView;
import android.widget.Toast;

import androidx.annotation.RequiresApi;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public class MainActivity extends WearableActivity {

    private TextView mTextView;
    private TextView tEdad;
    private TextView tFCardiaca;
    private EditText eEdad;
    private Button bMedir;
    private Button bNoMedir;



    private TextView pulso;
    private Spinner spinner;

    int UPDATE_PERIOD=1; //minutos


    public Context context;

    Alarm alarm;
    ArrayList<String> pulsos;

    int c=0;

    String fichero_leido;



    @RequiresApi(api = Build.VERSION_CODES.O)
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);

        //Inicialización de variables
        mTextView = (TextView) findViewById(R.id.text);
        tEdad = (TextView) findViewById(R.id.tEdad);
        tFCardiaca = (TextView) findViewById(R.id.tFCardiaca);
        eEdad = (EditText) findViewById(R.id.eEdad);


        pulso=(TextView) findViewById(R.id.pulso);
        spinner = (Spinner) findViewById(R.id.sIntervalo);
        context=this;
        pulsos=new ArrayList<>();
        bMedir=(Button) findViewById(R.id.bMedir);
        bNoMedir=(Button) findViewById(R.id.bNoMedir);
        spinner.setEnabled(false);
        bMedir.setEnabled(false);
        bNoMedir.setEnabled(false);

        //Inicializamos el spinner con los intervalos de actualizacion
        ArrayAdapter<CharSequence> adapter = ArrayAdapter.createFromResource(this,
                R.array.intervalos_actualizacion, R.layout.spinner_item);
        adapter.setDropDownViewResource(R.layout.spinner_dropdown_item);
        spinner.setAdapter(adapter);
        //Listener para el spinner
        spinner.setOnItemSelectedListener(
                new AdapterView.OnItemSelectedListener() {
                    public void onItemSelected(AdapterView<?> parent,
                                               android.view.View v, int position, long id) {
                        if(position==0){
                        }
                        else{
                            int seleccion=Integer.parseInt(parent.getItemAtPosition(position).toString());
                            Log.d("onItemSelected()",""+seleccion);
                            UPDATE_PERIOD=seleccion;//en milis

                            if(bNoMedir.isEnabled()){
                                alarm.cancelAlarm(getApplicationContext());
                            }

                            //Se recalculan rangos
                            Intent myIntent = new Intent("Medir");
                            myIntent.putExtra("Mide", 3.0);
                            LocalBroadcastManager.getInstance(context).sendBroadcast(myIntent);

                            alarm =new Alarm();
                            alarm.setAlarm(getApplicationContext(), UPDATE_PERIOD);
                            bNoMedir.setEnabled(true);
                            Toast.makeText(getApplicationContext(),
                                    "MIDIENDO...", Toast.LENGTH_SHORT).show();
                        }
                    }
                    @Override
                    public void onNothingSelected(AdapterView<?> parent) {

                    }

                });

        //Permiso de acceso a sensores
        if (ContextCompat.checkSelfPermission(this, Manifest.permission.BODY_SENSORS)
                != PackageManager.PERMISSION_GRANTED) {
            ActivityCompat.requestPermissions(this,
                    new String[]{Manifest.permission.BODY_SENSORS},
                    1);
        }


        //Se inicia el servicio para transferir datos entre el reloj y el movil
        Intent myIntent = new Intent(this,TransferService.class);
        startForegroundService(myIntent);

        //Se registra un receptor de broadcast para recibir datos desde LocalService
        LocalBroadcastManager.getInstance(this).registerReceiver(
                mMessageReceiver, new IntentFilter("DatosInterfaz"));


        //Se obtienen los datos de edad y frecuencia de reposo guardados para mostrarlo en la interfaz
        refrescarDatosUsuario();


        Intent myIntent2 = new Intent(context,LocalService.class);
        context.startForegroundService(myIntent2);


        SensorManager sensorManager = (SensorManager)
                getSystemService(SENSOR_SERVICE);
        List<Sensor> listaSensores = sensorManager.
                getSensorList(Sensor.TYPE_ALL);
        for(Sensor sensor: listaSensores) {
            Log.d("SENSOR",sensor.getStringType());
        }

    }


    @RequiresApi(api = Build.VERSION_CODES.O)
    @Override
    protected void onResume() {
        Log.d("ON RESUMEEE","ON RESUMEEE");

        super.onResume();

    }

    @Override
    protected void onDestroy(){
        alarm.cancelAlarm(this);
        alarm=null;
        super.onDestroy();
    }



    //Para recibir los datos desde el LocalService y actualizar la interfaz
    private BroadcastReceiver mMessageReceiver = new BroadcastReceiver() {
        @Override
        public void onReceive(Context context, Intent intent) {
            Log.d("RECIBIDOOOOOO","RECIBIDOOOOOOO");

            Date d=new Date(System.currentTimeMillis());
            String[] a=d.toString().split(" ");

            String datos_recibidos=intent.getStringExtra("Datos");
            if(datos_recibidos.equals("CalibracionFinalizada")){
                refrescarDatosUsuario();
            }
            else{
                pulso.setText("["+a[3]+"]: "+datos_recibidos);
            }
        }
    };


    @RequiresApi(api = Build.VERSION_CODES.O)
    public void onClickBMedir(View view){

        Log.d("onClickBMedir()","Pulsado");


        Intent myIntent = new Intent("Medir");
        myIntent.putExtra("Mide", 1.0);
        LocalBroadcastManager.getInstance(context).sendBroadcast(myIntent);

    }

    public void onClickBNoMedir(View view) {
        Log.d("onClickBNOMedir()","Pulsado");

        alarm.cancelAlarm(this);
        spinner.setSelection(0);
        bNoMedir.setEnabled(false);

    }
    public void onClickBCalibrar(View view) {
        Log.d("onClickBCalibrar()","Pulsado");
        Intent myIntent = new Intent("Medir");
        myIntent.putExtra("Mide", 2.0);
        LocalBroadcastManager.getInstance(context).sendBroadcast(myIntent);
    }

    public void onClickBConfEdad(View view) {
        Log.d("onClickBConf()","Pulsado");
        String s= String.valueOf(eEdad.getText());
        Log.d("XXXXX",s);
        s=s;
        if(!s.equals("")){
            int edad=Integer.valueOf(s);
            if(edad>=0 && edad<=100){
                escribirEnFicheroP("Edad.txt",s);
            }
        }
        refrescarDatosUsuario();
        tEdad.clearFocus();
    }


    public void onClickBLeerFichero(View view){
    }

    public void refrescarDatosUsuario(){
        String fc=leerFichero("PulsoCalibrado.txt");
        String edad=leerFichero("Edad.txt");

        if(fc!="" && edad!=""){
            tEdad.setText("Edad:" +edad.split("\n")[0]);
            tFCardiaca.setText("FC Reposo: "+fc.substring(0,2));
            bMedir.setEnabled(true);
            spinner.setEnabled(true);
        }
        else if(fc!=""){
            tFCardiaca.setText("FC Reposo: "+fc.substring(0,2));
        }
        else if(edad!=""){
            tEdad.setText("Edad:" +edad.split("\n")[0]);
        }
        else{
            tEdad.setText("Introducir edad");
            tFCardiaca.setText("Calibrar frecuencia cardiaca");
        }
        Intent myIntent = new Intent("Medir");
        myIntent.putExtra("Mide", 3.0);
        LocalBroadcastManager.getInstance(context).sendBroadcast(myIntent);
    }


    public void escribirEnFichero(String filename, String datos){

        try {
            FileOutputStream fou = openFileOutput(filename, Context.MODE_APPEND);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(fou);
            outputStreamWriter.append(datos+"\n");
            outputStreamWriter.close();
        }catch (IOException e) {
            Log.e("Exception", "File write failed: " + e.toString());
        }
    }
    public void escribirEnFicheroP(String filename, String datos){

        try {
            FileOutputStream fou = openFileOutput(filename, Context.MODE_PRIVATE);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(fou);
            outputStreamWriter.write(datos+"\n");
            outputStreamWriter.close();
        }catch (IOException e) {
            Log.e("Exception", "File write failed: " + e.toString());
        }
    }
    public String leerFichero(String nombre){
        fichero_leido="";
        try {
            InputStream inputStream = openFileInput(nombre);

            if (inputStream != null) {
                InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
                BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                String receiveString = "";

                while ((receiveString = bufferedReader.readLine()) != null) {
                    //Log.d("leerFichero",receiveString);
                    fichero_leido=fichero_leido+receiveString+"\n";
                }
                inputStream.close();
            }
        } catch (FileNotFoundException e) {
            Log.e("login activity", "File not found: " + e.toString());
        } catch (IOException e) {
            Log.e("login activity", "Can not read file: " + e.toString());
        }
        return fichero_leido;
    }
}
